/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.filebrowser;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_6379;
import potionstudios.byg.client.config.configeditor.ConfigEditScreen;
import potionstudios.byg.client.config.filebrowser.KeyCommentToolTipEntry;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;
import potionstudios.byg.mixin.access.client.ScreenAccess;
import potionstudios.byg.util.BYGUtil;

public class FileEntry<T>
extends KeyCommentToolTipEntry<T> {
    private static final class_2585 RELOADS_ON_SAVE = new class_2585("Reloads on save");
    private static final class_2585 DOES_NOT_RELOAD_ON_SAVE = new class_2585("Does not Reload on save");
    private static final class_2585 RELOAD = new class_2585("Reload");
    private final class_4185 openFileButton;
    private final class_4185 editButton;
    private final class_4185 reloadButton;
    private final boolean isReloadable;
    private boolean overrideDefaultToolTip;
    private int lastReload = -1;

    public FileEntry(boolean isReloadable, class_437 parent, final String relativizedPath, Path absolutePath, Consumer<Path> onReload) {
        super(parent, relativizedPath, relativizedPath);
        this.isReloadable = isReloadable;
        this.openFileButton = new class_4185(0, 0, 50, 20, (class_2561)new class_2588("Open"), button -> ((ScreenAccess)parent).byg_invokeOpenLink(absolutePath.toUri())){

            protected class_5250 method_25360() {
                return new class_2588("narrator.controls.reset", new Object[]{relativizedPath});
            }
        };
        ConfigEntriesSerializer<?> serializer = ConfigEntriesSerializer.fromFile(absolutePath);
        this.editButton = new class_4185(0, 0, 50, 20, (class_2561)new class_2588("Edit"), button -> {
            if (serializer != null) {
                class_310.method_1551().method_1507((class_437)new ConfigEditScreen(this.parent, serializer, relativizedPath, absolutePath, isReloadable));
            }
        }){

            protected class_5250 method_25360() {
                return new class_2588("narrator.controls.reset", new Object[]{relativizedPath});
            }
        };
        class_2588 reload = new class_2588("Reload");
        this.reloadButton = new class_4185(0, 0, 50, 20, (class_2561)reload, button -> {
            if (isReloadable) {
                onReload.accept(absolutePath);
            }
            this.lastReload = 60;
            button.field_22763 = false;
        }){

            protected class_5250 method_25360() {
                return new class_2588("narrator.controls.reset", new Object[]{relativizedPath});
            }
        };
        this.reloadButton.field_22763 = isReloadable;
        if (serializer == null) {
            this.editButton.field_22763 = false;
        }
    }

    @Override
    public void method_25343(class_4587 pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        super.method_25343(pPoseStack, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
        this.editButton.field_22760 = (int)(this.keyScreenPosition.x + (float)this.maxKeyWidth + 20.0f);
        this.editButton.field_22761 = pTop + pHeight / 2 - 9;
        this.editButton.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.openFileButton.field_22760 = this.editButton.field_22760 + this.editButton.method_25368() + 10;
        this.openFileButton.field_22761 = this.editButton.field_22761;
        this.openFileButton.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.reloadButton.field_22760 = this.openFileButton.field_22760 + this.openFileButton.method_25368() + 10;
        this.reloadButton.field_22761 = this.openFileButton.field_22761;
        this.reloadButton.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        int minX = pLeft - 15;
        int maxX = pLeft - 5;
        int minY = pTop;
        int maxY = pTop + pHeight;
        this.overrideDefaultToolTip = BYGUtil.isInside(minX, minY, maxX, maxY, pMouseX, pMouseY);
        if (this.overrideDefaultToolTip) {
            if (this.toolTip.get(0) != RELOADS_ON_SAVE) {
                this.toolTip.clear();
                this.toolTip.add(this.isReloadable ? RELOADS_ON_SAVE : DOES_NOT_RELOAD_ON_SAVE);
            }
            this.renderToolTip = true;
        } else {
            this.renderToolTip = pIsMouseOver;
        }
        class_332.method_25294((class_4587)pPoseStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)(this.isReloadable ? class_5253.class_5254.method_27764((int)255, (int)0, (int)255, (int)0) : class_5253.class_5254.method_27764((int)255, (int)255, (int)0, (int)0)));
    }

    @Override
    public boolean toolTipCacheReload(int pWidth, boolean pIsMouseOver) {
        if (this.overrideDefaultToolTip) {
            return false;
        }
        return super.toolTipCacheReload(pWidth, pIsMouseOver);
    }

    public List<? extends class_6379> method_37025() {
        return ImmutableList.of((Object)this.openFileButton, (Object)this.editButton, (Object)this.reloadButton);
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)this.openFileButton, (Object)this.editButton, (Object)this.reloadButton);
    }

    @Override
    public int getRowLength() {
        return super.getRowLength() + 20 + this.openFileButton.method_25368() + 10 + this.openFileButton.method_25368() + 10 + this.reloadButton.method_25368();
    }

    public boolean method_25402(double $$0, double $$1, int $$2) {
        return super.method_25402($$0, $$1, $$2);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastReload > 0) {
            --this.lastReload;
            this.reloadButton.method_25355((class_2561)new class_2585(Integer.toString(this.lastReload / 20 + 1)));
        } else if (this.lastReload == 0) {
            this.reloadButton.method_25355((class_2561)RELOAD);
            this.reloadButton.field_22763 = true;
        }
    }
}

